/*************************************************************************
Crytek Source File.
Copyright (C), Crytek Studios, 2001-2004.
-------------------------------------------------------------------------
$Id: AnimActionEditorDialog.h,v 1.1 2008/12/12 17:45:51 PauloZaffari Exp wwwrun $
$DateTime$
Description:  This is the source file for the dialog NewAnimActionDialog.
The purpose of this dialog is to allow the user to choose from the set of
AnimAction classes one for his new AnimAction. It also allows the user to
type the name for his new AnimAction.
-------------------------------------------------------------------------
History:
- 12:12:2008   17:45 : Created by Paulo Zaffari

*************************************************************************/
#include "stdafx.h"

#include "NewAnimActionDialog.h"

#include <IAnimAction.h>
#include "Support\EditorAnimActionManager.h"

CNewAnimActionDialog::CNewAnimActionDialog():
CDialog(IDD_NEW_ANIMACTION_DIALOG),
m_piAnimActionClass(NULL)
{
	m_strAnimActionName="New AnimAction";
}

void CNewAnimActionDialog::DoDataExchange(CDataExchange* pDX)
{
	__super::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_NEW_ANIMACTION_ANIMACTION_CLASSES_COMBO, m_ComboBox);
	DDX_Control(pDX,IDC_NEW_ANIMACTION_NAME_EDIT, m_NameEdit);
	DDX_Text(pDX,IDC_NEW_ANIMACTION_NAME_EDIT, m_strAnimActionName);
}

BOOL CNewAnimActionDialog::OnInitDialog()
{
	if (__super::OnInitDialog() == FALSE)
		return FALSE;

	SetWindowText(m_strAnimActionName);

	UpdateData(FALSE);

	CEditorAnimActionManager									&roEditorAnimActionManager=CEditorAnimActionManager::GetAnimActionManager();
	CEditorAnimActionManager::TDAnimActions		cAnimActionClasses;

	size_t																		nTotalAnimActionClasses(0);
	size_t																		nCurrentAnimActionClass(0);
	int																				nInsertedItem(0);
	IAnimActionClass*													piAnimActionClass(NULL);

	roEditorAnimActionManager.GetAnimActionClasses(cAnimActionClasses);

	nTotalAnimActionClasses=cAnimActionClasses.size();
	for (nCurrentAnimActionClass=0;nCurrentAnimActionClass<nTotalAnimActionClasses;++nCurrentAnimActionClass)
	{
		piAnimActionClass=cAnimActionClasses[nCurrentAnimActionClass];
		nInsertedItem=m_ComboBox.AddString(piAnimActionClass->GetAAClassName());
		m_ComboBox.SetItemData(nInsertedItem,(DWORD_PTR)piAnimActionClass);
	}
	m_ComboBox.SetCurSel(0);

	m_NameEdit.SetWindowText("New AnimAction");

	return TRUE;
}

void CNewAnimActionDialog::OnOK()
{
	int	nCurrentSelection(0);

	UpdateData(TRUE);

	nCurrentSelection=m_ComboBox.GetCurSel();
	m_piAnimActionClass=(IAnimActionClass*)m_ComboBox.GetItemData(nCurrentSelection);

	__super::OnOK();
}

IAnimActionClass* CNewAnimActionDialog::GetAnimActionClass()
{
	return m_piAnimActionClass;
}

CString						CNewAnimActionDialog::GetAnimActionFilename()
{
	return m_strAnimActionName;
}
